
 
; Off-hook timer


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_ON & _MCLRE_ON & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT	


; RAM 

STORE1			equ	H'20'	; delay/ counter	
STORE2			equ	H'21'	; delay/ counter
STORE3			equ	H'22'	; delay/ counter
STORE4			equ	H'23'	; delay/ counter
TIMER			equ	H'24'	; timer setting
MINUTE			equ	H'25'	; minute
FLASH			equ	H'26'	; flash ready flag
BLINK			equ H'27'	; blink flag

	
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
	    				; interrupt vector 
	org		4

	
; ***********************************************************
		
VALUES

	addwf	PCL,f			; lookup table for timing values
	retlw	D'15'			; 15 minutes
	retlw	D'30'
	retlw	D'60'
	retlw	D'90'
	retlw	D'120'			; 120 minutes

MAIN


	bsf		STATUS,RP0	; bank 1
; set oscillator calibration
	call	H'3FF'		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	clrf	GPIO		; outputs low
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	clrf	ANSEL		; digital I/O
	movlw	B'00000001'	; pullups on/off
	movwf	WPU
	movlw	B'00000001'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00000000'	; settings (pullups enabled) wdt prescaler/128 (18ms x 128 timeout)
	movwf	OPTION_REG
; interrupts
	bsf 	INTCON,GPIE		; interrupt on change enable
	bsf 	IOC,0			; change on GPI0,0
	bcf		STATUS,RP0		; select memory bank 0

; initial
; set timer between 0 and 4
	movf	TIMER,w
	sublw	D'4'		; subtract from 4
	clrw
	btfss	STATUS,C	; if negative (above 4) clear TIMER
	movwf	TIMER

MCLR_RESET
ON_HOOK

	clrf	GPIO			; reset outputs
	movlw	D'10'
	call	DELAY			; delay 100ms

	movf	GPIO,w
	bcf		INTCON,GPIF		; clear flag
	sleep					; stop, wait for switch S1	
	nop
; check if glitch or genuine closure
	movlw	D'10'
	call	DELAY			; delay 100ms
	btfsc	GPIO,0
	goto	MCLR_RESET
OFF_HOOK
	bsf		GPIO,1		; off hook
	movlw	D'5'
	movwf	FLASH		; time till LEDs flash timing down
	clrf	BLINK
	movlw	D'60'		; 60 for 1 minute
	movwf	MINUTE
	movf	TIMER,w		; timer value
	call	VALUES		; get equivalent timeout
	movwf	STORE1

; set timer LEDs
	call	LEDs
WAIT
	movlw	D'10'
	call	DELAY			; delay 100ms
; wait for switch to be open

	btfss	GPIO,0
	goto	WAIT	
; set timer as per setting 0-4
; TIMER value converted in Value lookup table to 120, 90, 60, 30, 15mins. Min = 15, Max = 120
; LEDs show these settings
TIME_SET
	movlw	D'5'
	movwf	FLASH		; time till LEDs flash timing down
	clrf	BLINK
	movlw	D'60'		; 60 for 1 minute
	movwf	MINUTE
	movf	TIMER,w		; timer value
	call	VALUES		; get equivalent timeout
	movwf	STORE1

; set timer LEDs
	call	LEDs
TIMING
; 1s timer
	call	ONE_HALFSECOND	; 1/2s timer
	call	LEDs
	call	ONE_HALFSECOND	; 1s total
	
; if w is zero then bypass flash as 1/2s period is exited before the 1/2s due to Switch
; if w is 1 then decrease flash value
	xorlw	D'1'
	btfss	STATUS,Z
	goto	BY_INC	
	movf	FLASH,w
	btfss	STATUS,Z	; when zero stop decrease
	decf	FLASH,f

BY_INC
	
; check if S1 closed
	btfss	GPIO,0		; if low then increment timer to 15, 30, 60, 90 and 120m 
	goto	INCREASE
	call	LEDs
	goto	TIMING_CONT
INCREASE
; if timing then wait for switch to open
	movf	FLASH,w
	btfss	STATUS,Z
	goto	NEXT
WAIT1
	movlw	D'10'
	call	DELAY			; delay 100ms
; wait for switch to be open

	btfss	GPIO,0
	goto	WAIT1
	goto	TIME_SET 
NEXT
	call	INC_TIMER
; set timer LEDs
	call	LEDs
	movlw	D'10'		; increase rate with switch pressed and released
; if held down delay is totalled with delays below
	call	DELAY
; check switch
	btfsc	GPIO,0		; if open continue
	goto	TIMING_CONT
	movlw	D'10'		; increase rate with switch held down totalled
	call	DELAY
; check switch
	btfsc	GPIO,0		; if open continue
	goto	TIMING_CONT
	movlw	D'10'		; increase rate with switch held down totalled
	call	DELAY

; check switch
	btfss	GPIO,0		; if open continue

; if closed increase timer again 				
	goto	TIME_SET
TIMING_CONT
	movf	MINUTE,w
	btfss	STATUS,Z	; when zero set at 60
	goto	CYCLE
	movlw	D'60'		; 60 for 1 minute
	movwf	MINUTE
; decrease STORE1 every minute
; when zero end of time period so on Hook
	movf	STORE1,w
	btfsc	STATUS,Z
	goto	ON_HOOK
	decf	STORE1,f

CYCLE
	decf	MINUTE,f	; count seconds down
	goto	TIMING

; subroutines
	
INC_TIMER ; 

	incf	TIMER,f
	movf	TIMER,w
	sublw	D'4'		; subtract from 4
	clrw
	btfss	STATUS,C	; if negative clear TIMER
	movwf	TIMER
	movf	TIMER,w
	call	VALUES		; get equivalent timeout
	movwf	STORE1
	return	

LEDs ; show LEDs based on STORE1


; flash on and off during timing
; wait for start
	movf	FLASH,w
	btfsc	STATUS,Z
	goto	FLASHING
LEDS_ON
	call	LEDS_RUN 	; use LEDS_RUN_ALT for reverse direction of timer values
	movwf	GPIO
	return

FLASHING
	incf	BLINK,f
	btfss	BLINK,0
	goto	LEDS_ON
	movlw	B'00000010'
	movwf	GPIO		; LEDs off
	return	
	
LEDS_RUN_ALT ; (120m at left, 15m at right)
;(120m)	
	movlw	D'91'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >90
	retlw	B'00000110'	; light LED3 and Q1,Q2 on 
;(90m)	
	movlw	D'61'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >60
	retlw	B'00010110'	; LEDs 2 & 3 and Q1,Q2 on 
;(60m)
	movlw	D'31'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >30
	retlw	B'00010010'	; LED 2 and Q1,Q2 on 
;(30m)
	movlw	D'16'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >15
	retlw	B'00110010'	; LEDs 2 & 1 and Q1,Q2 on 
;(15m)
	retlw	B'00100010'	; LED 1 and Q1 and Q2 on 

LEDS_RUN ; (120m at right, 15m at left)
; (120m)
	movlw	D'91'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >90
	retlw	B'00100010'	; LED 1 and Q1 and Q2 on
; (90m)	
	movlw	D'61'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >60
	retlw	B'00110010'	; LEDs 2 & 1 and Q1,Q2 on
; (60m)
	movlw	D'31'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >30
	retlw	B'00010010'	; LED 2 and Q1,Q2 on
; (30m)
	movlw	D'16'
	subwf	STORE1,w
	btfsc	STATUS,C	; if >15
	retlw	B'00010110'	; LEDs 2 & 3 and Q1,Q2 on
; (15m)
	retlw	B'00000110'	; light LED3 and Q1,Q2 on


ONE_HALFSECOND ; 1/2s timer
	movlw	D'30'		; 30 for 1/2 second timer
	movwf	STORE4
LOOP1
; check if S1 closed
	btfss	GPIO,0
	retlw	D'0'		; zero returned if less than 1s
	movlw	D'22'		; delay value
	movwf	STORE3		; STORE1 is number of loops value
LOOP2
	movlw	D'247'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP3
	decfsz	STORE2,f
	goto	LOOP3
	decfsz	STORE3,f
	goto	LOOP2
	decfsz	STORE4,f
	goto	LOOP1
	retlw	D'1'		; 1 returned for 1s

DELAY
	movwf	STORE4
LOOP11
	movlw	D'22'		; delay value
	movwf	STORE3		; STORE1 is number of loops value
LOOP21
	movlw	D'247'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP31
	decfsz	STORE2,f
	goto	LOOP31
	decfsz	STORE3,f
	goto	LOOP21
	decfsz	STORE4,f
	goto	LOOP11
	return

	end
